<?php

namespace App\Http\Controllers;

use App\TipoCar;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class TipoCarController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;
        if ($request->buscar == '') {
            $tipoCars = TipoCar::join('marcas','tipoCars.marca_id','marcas.id')
            ->select('tipoCars.id','tipoCars.marca_id','tipoCars.tipo','tipoCars.estado','tipoCars.user_id','marcas.marca')
            ->orderBy('tipoCars.id', 'asc')
            ->paginate(10);
        } else {
            $tipoCars = TipoCar::join('marcas','tipoCars.marca_id','marcas.id')
            ->select('tipoCars.id','tipoCars.marca_id','tipoCars.tipo','tipoCars.estado','tipoCars.user_id','marcas.marca')
            ->where(function ( $query ) use ($buscar) {
                $query->orWhere('marca','like',$buscar.'%')
                        ->orWhere('tipo','like',$buscar.'%');
            })
            ->orderBy('tipoCars.id', 'asc')
            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $tipoCars->total(),
                'current_page'  => $tipoCars->currentPage(),
                'per_page'      => $tipoCars->perPage(),
                'last_page'     => $tipoCars->lastPage(),
                'from'          => $tipoCars->firstItem(),
                'to'            => $tipoCars->lastItem(),

            ],
            'tipoCars' => $tipoCars
        ]);
    }

    public function comboSelectTipoCar(Request $request) {
        if(!$request->ajax()) return view('/');
        $buscar = $request->marca_id;
       // return var_dump($buscar);
        if (!$request->ajax()) return redirect('/');
       $tipoCar = TipoCar::where('marca_id','=',$buscar)
       ->where('estado','=','1')
       ->select('id as tipoCar_id','marca_id','tipo')->orderBy('id', 'asc')->get();
       return response()->json($tipoCar);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $marca_id = $request->marca_id;
        $tipo = $request->tipo;
        $tipoCar = TipoCar::select('marca_id','tipo')
        ->where('marca_id', $marca_id)
        ->where('tipo', $tipo)
        ->first();
        //return response()->json($doc);
        if(!empty($tipoCar)){
            return response()->json("existe");
              //return "existe";
        } else {
            $tipoCar = new TipoCar();
            $tipoCar->marca_id = $request->marca_id;
            $tipoCar->tipo = $request->tipo;
            $tipoCar->estado = '1';
            $tipoCar->user_id = Auth::user()->id;
            $tipoCar->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        $id = $request->id;
        $marca_id = $request->marca_id;
        $tipo = $request->tipo;
        $tipoCar = TipoCar::select('id','marca_id','tipo')
        ->where('marca_id', $marca_id)
        ->where('tipo', $tipo)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($tipoCar)){
            return response()->json("existe");
             //return "existe";
        } else {
            $tipoCar = TipoCar::findOrFail($request->id);
            $tipoCar->marca_id = $request->marca_id;
            $tipoCar->tipo = $request->tipo;
            $tipoCar->estado = '1';
            $tipoCar->user_id = Auth::user()->id;
            $tipoCar->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $tipoCar           = TipoCar::findOrFail($request->id);
        $tipoCar->estado   = $request->estado;
        $tipoCar->save();
    }
}
