<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\DB;

class RoleController extends Controller
{
    public function ListarRol(Request $request){
        if ($request->buscar == '') {
            $roles = Role::orderBy('name')
            ->paginate(10);
        } else {
            $roles = Role::where('name','LIKE','%'.$request->buscar.'%')
                        ->orderBy('name')
                        ->paginate(10);
        }



        return response()->json([
            'pagination' => [
                'total'         => $roles->total(),
                'current_page'  => $roles->currentPage(),
                'per_page'      => $roles->perPage(),
                'last_page'     => $roles->lastPage(),
                'from'          => $roles->firstItem(),
                'to'            => $roles->lastItem(),

            ],
            'roles' => $roles
        ]);
    }

    public function GuardarRol(Request $request) {
        $rol = Role::create(['name' => $request->nombre, 'detalle'=>$request->descripcion]);
        $data = [];
        $permisos = $request->listarpermisos;
        foreach ($permisos as $key => $value) {
            if ($value['checked']) {
                // $data[$key] = $value['name'];
                array_push($data,$value['name']);
            }
        }
        $rol->syncPermissions($data);

        return response()->json($data);
    }

    public function ListaRolPermiso(Request $request){
        $id = $request->id;
        $rol = Role::find($id);
        $datos = DB::table('role_has_permissions as rp')
        ->select('p.name', 'p.id as idper','rp.role_id', 'p.detalle','m.nombre as modulo'
         ,DB::raw("CASE  WHEN COALESCE(rp.role_id,0) = 0 THEN 0 ELSE 1 END AS checked")
        )
        ->rightJoin('permissions as p', function($join) use ($id){
            $join->on('p.id','=','rp.permission_id')
                ->where('rp.role_id',$id);
        })
        ->join('modulos as m', 'p.mod_cod','m.id')
        ->get();

        return response()->json([
            'rol'=> $rol,
            'permisos' => $datos
        ]);
    }

    public function EditarRol(Request $request){
         Role::where('id',$request->id)
        ->update(['name' => $request->nombre, 'detalle' => $request->descripcion]);

        $rol = Role::find($request->id);
        DB::table('role_has_permissions')
            ->where('role_id',$request->id)
            ->delete();

        $data = [];
        $permisos = $request->listarpermisos;
        foreach ($permisos as $key => $value) {
            if ($value['checked']) {
                // $data[$key] = $value['name'];
                array_push($data,$value['name']);
            }
        }
        $rol->syncPermissions($data);

        return response()->json($data);
    }

    public function desactivarRol(Request $request) {
        $rol = Role::findOrFail($request->id);
        $rol->estado = '0';
        $rol->save();
    }

    public function activarRol(Request $request) {
        $rol = Role::findOrFail($request->id);
        $rol->estado = '1';
        $rol->save();
    }

    public function ListarRoles() {
        $role = Role::all();

        return response()->json($role);
    }

    public function selectRol(Request $request){
        if (!$request->ajax()) return redirect('/');
       $roles = Role::where('estado','=','1')
       ->orderBy('id', 'asc')->get();
       return ['roles' => $roles];
   }
}
