<?php

namespace App\Http\Controllers;

use App\Personal;
use App\PersonalCargo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class PersonalCargoController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;
        if ($buscar == '')
        {
            $personal_cargos = PersonalCargo::join('cargos','sindicatoCargos.cargo_id','cargos.id')
                                            ->join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
                                            ->select('sindicatoCargos.id','sindicatoCargos.per_codigo','sindicatoCargos.cargo_id',
                                            'sindicatoCargos.fechaInicio','sindicatoCargos.fechaFin','sindicatoCargos.observacion',
                                            'sindicatoCargos.estado','sindicatoCargos.user_id',
                                            'cargos.id as idcargo','cargos.descripcion',
                                            'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre',
                                            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as completo"))
                                            ->where('sindicatoCargos.estado',1)
                                            ->orderBy('sindicatoCargos.cargo_id','asc')
                                            ->paginate(10);
        } else
        {
            $personal_cargos = PersonalCargo::join('cargos','sindicatoCargos.cargo_id','cargos.id')
                                            ->join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
                                            ->select('sindicatoCargos.id','sindicatoCargos.per_codigo','sindicatoCargos.cargo_id',
                                            'sindicatoCargos.fechaInicio','sindicatoCargos.fechaFin','sindicatoCargos.observacion',
                                            'sindicatoCargos.estado','sindicatoCargos.user_id',
                                            'cargos.id as idcargo','cargos.descripcion',
                                            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
                                            'personals.per_paterno as paterno',
                                            'personals.per_materno as materno',
                                            'personals.per_nombre as nombre',
                                            'personals.per_ci'
                                            )
                                            ->where(function ( $query ) use ($buscar) {
                                                $query->orWhere('per_celular','like',$buscar.'%')
                                                        ->orWhere('per_ci','like',$buscar.'%')
                                                        ->orWhere('per_nombre','like',$buscar.'%')
                                                        ->orWhere('per_paterno','like',$buscar.'%')
                                                        ->orWhere('per_materno','like',$buscar.'%')
                                                        ->orWhere('cargos.descripcion','like',$buscar.'%')
                                                        ->orWhere( DB::raw("CONCAT(per_paterno,' ',per_materno,' ',per_nombre)"),'like',$buscar.'%');
                                            })
                                            ->orderBy('sindicatoCargos.fechaInicio','desc')
                                            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $personal_cargos->total(),
                'current_page'  => $personal_cargos->currentPage(),
                'per_page'      => $personal_cargos->perPage(),
                'last_page'     => $personal_cargos->lastPage(),
                'from'          => $personal_cargos->firstItem(),
                'to'            => $personal_cargos->lastItem(),

            ],
            'personal_cargos' => $personal_cargos
        ]);
    }

    public function store(Request $request){
        if(!$request->ajax()) return redirect('/');
        $per_codigo     = $request->per_codigo;
        $cargo_id       = $request->cargo_id;
        $fechaInicio    = $request->fechaInicio;
        $reemplazo      = $request->reemplazo;

        $cargPersoCargo = PersonalCargo::select('per_codigo','cargo_id','fechaInicio')
        ->where('per_codigo', $per_codigo)
        ->where('cargo_id', $cargo_id)
        ->where('fechaInicio', $fechaInicio)
        ->first();
        //return response()->json($doc);
        if(!empty($cargPersoCargo)){
            return response()->json("existe");
            //return "existe";
        } else {
            $estado = PersonalCargo::select('id','cargo_id','estado')
            ->where('cargo_id', $cargo_id)
            ->where('estado', 1)->first();
            if(empty($estado)){
                $cargPersoCargo = new PersonalCargo();
                $cargPersoCargo->per_codigo     = $request->per_codigo;
                $cargPersoCargo->cargo_id       = $request->cargo_id;
                $cargPersoCargo->fechaInicio    = $request->fechaInicio;
              //  $cargPersoCargo->fechaFin       = $request->fechaFin;
                $val = $request->observacion;

                if($val == '')
                {
                    $val = 'NINGUNO';
                }
                else{
                    $val = $request->observacion;
                }
                $cargPersoCargo->observacion    = $val;
                $cargPersoCargo->estado         = '1';
                $cargPersoCargo->user_id        = Auth::user()->id;
                $cargPersoCargo->save();
                return response()->json("exitoso");
            } else {
                try {

                    DB::beginTransaction();
                    $estadoId = $estado->id;
                    $this->ActualizarExistente($reemplazo,$fechaInicio);
                    $this->Estado($estadoId);
                    $cargPersoCargo = new PersonalCargo();
                    $cargPersoCargo->per_codigo     = $request->per_codigo;
                    $cargPersoCargo->cargo_id       = $request->cargo_id;
                    $cargPersoCargo->fechaInicio    = $request->fechaInicio;
                    $val = $request->observacion;

                    if($val == '')
                    {
                        $val = 'NINGUNO';
                    }
                    else{
                        $val = $request->observacion;
                    }
                    $cargPersoCargo->observacion    = $val;
                    $cargPersoCargo->estado         = '1';
                    $cargPersoCargo->user_id        = Auth::user()->id;
                    $cargPersoCargo->save();
                    DB::commit();
                } catch (\Exception $e) {
                    DB::rollback();
                    return response()->json("falla");
                }
                return response()->json("exitoso");
            }
        }
    }

    public function Estado($estadoId){
        PersonalCargo::where('id', $estadoId)
          ->where('estado', 1)
          ->update(['estado' => 0]);
    }

    public function ActualizarExistente($reemplazo,$fechaInicio) {
        PersonalCargo::where('id', $reemplazo)
        ->where('fechaFin', Null)
        ->update(['fechaFin' => $fechaInicio]);
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        $id = $request->id;
        $per_codigo = $request->per_codigo;
        $cargo_id = $request->cargo_id;
        $fechaInicio = $request->fechaInicio;
        $personal_cargos = PersonalCargo::select('id','per_codigo','cargo_id','fechaInicio')
                        ->where('per_codigo', $per_codigo)
                        ->where('cargo_id', $cargo_id)
                        ->where('fechaInicio', $fechaInicio)
                        ->whereNotIn('id', [$id])
                        ->first();
        if(!empty($personal_cargos)){
            return response()->json("existe");
        } else {
            $personal_cargos                =   PersonalCargo::findOrFail($request->id);
            $personal_cargos->per_codigo    =   $request->per_codigo;
            $personal_cargos->cargo_id      =   $request->cargo_id;
            $personal_cargos->fechaInicio   =   $request->fechaInicio;
            $val                            =   $request->observacion;
            if($val == ''){
                $val = 'NINGUNA';
            }
            else{
                $val = $request->observacion;
            }
            $personal_cargos->observacion   =   $val;
            $personal_cargos->user_id       =   Auth::user()->id;
            $personal_cargos->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');

        $personal_cargos           = PersonalCargo::findOrFail($request->id);
        $personal_cargos->estado   = $request->estado;
        $personal_cargos->save();
    }

    public function selectPersonal(Request $request){
        $personal = DB::table('personals')
                        ->select('personals.per_codigo',
                                DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as completo"),
                                'personals.per_paterno',
                                'personals.per_materno',
                                'personals.per_nombre',
                                'personals.per_ci')
                        //->whereNotIn('personals.tipoSocio_id',[3])
                        ->where('personals.estado',1)
                        ->orderBy('personals.per_paterno','asc')
                        ->get();
        return response()->json($personal);
    }

    public function selectCargo(Request $request) {
        $cargos = DB::table('cargos')
                    ->select('id','descripcion')
                    ->orderBy('id','asc')
                    ->get();
        return response()->json($cargos);
    }

    public function selectCargosPersonal(Request $request){
        $buscar = $request->cargo_id;

        $personalCargos = DB::table('sindicatoCargos')
        ->join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
        ->select('sindicatoCargos.id','sindicatoCargos.per_codigo','sindicatoCargos.cargo_id',
        DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as completo"),
        )
        ->where('sindicatoCargos.cargo_id','=',$buscar)
        ->where('sindicatoCargos.estado',1)
        ->orderBy('sindicatoCargos.id','asc')
        ->get();
        return response()->json($personalCargos);
    }

    public function ReportePersonalCargo() {
        $personal_cargos = PersonalCargo::join('cargos','sindicatoCargos.cargo_id','cargos.id')
                                            ->join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
                                            ->select('sindicatoCargos.id','sindicatoCargos.per_codigo','sindicatoCargos.cargo_id',
                                            'sindicatoCargos.fechaInicio','sindicatoCargos.fechaFin','sindicatoCargos.observacion',
                                            'sindicatoCargos.estado','sindicatoCargos.user_id',
                                            'cargos.id as idcargo','cargos.descripcion', 'personals.per_ci',
                                            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"))
                                            ->where('sindicatoCargos.estado',1)
                                            ->orderBy('sindicatoCargos.cargo_id','asc')
                                            ->get();
        $cargo1 = PersonalCargo::join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
                                        ->join('cargos','sindicatoCargos.cargo_id','cargos.id')
                                        ->select('cargos.descripcion',
                                        'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre')
                                        ->where('sindicatoCargos.estado',1)
                                        ->where('cargos.id',1)
                                        ->first();
        $total = DB::table('sindicatoCargos')
            ->select(DB::raw('count(*) as count'))
            ->where('estado',1)
            ->first()
            ->count;

        $meses = array("ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");
        $fecha_emision = date('d')." DE ".$meses[date('n')-1]." DEL ".date('Y');
        $qr = QrCode::encoding('UTF-8')->size(100)->generate("SINDICATO DE TRANSPORTE 16 DE JULIO TRUFI 7\nTOTAL REGISTROS: $total\nFECHA: $fecha_emision");
        $codigo = $qr;
        $pdf = PDF::loadView('reportes.personalCargos',['personalCargos'=>$personal_cargos,
                                                    'cargos'=>$cargo1,
                                                    'qr'=>$codigo])
                    ->setPaper('letter', 'landscape');

        return $pdf->stream('personalCargos.pdf');
    }
}
