<?php

namespace App\Http\Controllers;

use App\movimientoCajas;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class MovimientoCajaController extends Controller
{
    public function ingresos(Request $request){
        if(!$request->ajax()) return redirect('/');
        $ingresos =  movimientoCajas::where('estado',1)
        ->where('tipoCuenta_id',5)
        ->sum('monto');
        return response()->json($ingresos);
    }

    public function egresos(Request $request){
        if(!$request->ajax()) return redirect('/');
        $egresos =  movimientoCajas::where('estado',1)
        ->where('tipoCuenta_id',4)
        ->sum('monto');
        return response()->json($egresos);
    }

    public function index(Request $request){
        if(!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;
        if ($request->buscar == '') {
            $cajas = movimientoCajas::join('personals','movimientoCajas.per_codigo','personals.per_codigo')
            ->join('cuentaTipos','movimientoCajas.tipoCuenta_id','cuentaTipos.id')
            ->join('cuentas','movimientoCajas.cuenta_id','cuentas.id')
            ->join('tipoSocios','movimientoCajas.tipoSocio_id','tipoSocios.id')
            ->select('movimientoCajas.id','movimientoCajas.tipoCuenta_id','movimientoCajas.cuenta_id','movimientoCajas.per_codigo',
            'movimientoCajas.fecha','movimientoCajas.monto','movimientoCajas.estado','movimientoCajas.user_id','cuentaTipos.cuentaTipo',
            'cuentas.descripcion', DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
            'personals.per_paterno','personals.per_materno','personals.per_nombre','personals.per_ci')
            ->orderBy('movimientoCajas.id', 'desc')
            ->paginate(10);
        } else {
            $cajas = movimientoCajas::join('personals','movimientoCajas.per_codigo','personals.per_codigo')
            ->join('cuentaTipos','movimientoCajas.tipoCuenta_id','cuentaTipos.id')
            ->join('cuentas','movimientoCajas.cuenta_id','cuentas.id')
            ->join('tipoSocios','movimientoCajas.tipoSocio_id','tipoSocios.id')
            ->select('movimientoCajas.id','movimientoCajas.tipoCuenta_id','movimientoCajas.cuenta_id','movimientoCajas.per_codigo',
            'movimientoCajas.fecha','movimientoCajas.monto','movimientoCajas.estado','movimientoCajas.user_id','cuentaTipos.cuentaTipo',
            'cuentas.descripcion', DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as completo"),
            'personals.per_paterno','personals.per_materno','personals.per_nombre','personals.per_ci')
            ->where(function ( $query ) use ($buscar) {
                $query->orWhere('personals.per_nombre','like',$buscar.'%')
                        ->orWhere('personals.per_paterno','like',$buscar.'%')
                        ->orWhere('personals.per_materno','like',$buscar.'%')
                        ->orWhere('cuentaTipos.cuentaTipo','like',$buscar.'%')
                        ->orWhere('cuentas.descripcion','like',$buscar.'%');
            })
            ->orderBy('movimientoCajas.id', 'desc')
            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $cajas->total(),
                'current_page'  => $cajas->currentPage(),
                'per_page'      => $cajas->perPage(),
                'last_page'     => $cajas->lastPage(),
                'from'          => $cajas->firstItem(),
                'to'            => $cajas->lastItem(),

            ],
            'cajas' => $cajas
        ]);
    }

    public function store(Request $request){
        if(!$request->ajax()) return redirect('/');
        $tipoCuenta_id = $request->tipoCuenta_id;
        $cuenta_id = $request->cuenta_id;
        $fecha = $request->fecha;
        $per_codigo = $request->per_codigo;
        $tipoSocio_id = $request->tipoSocio_id;
        $monto = $request->monto;
        $movCaja = movimientoCajas::select('tipoCuenta_id','cuenta_id','per_codigo','tipoSocio_id','monto')
        ->where('tipoCuenta_id', $tipoCuenta_id)
        ->where('cuenta_id', $cuenta_id)
        ->where('per_codigo', $per_codigo)
        ->where('tipoSocio_id', $tipoSocio_id)
        ->where('monto', $monto)
        ->first();

        if(!empty($movCaja)){
            return response()->json(400);
              //return "existe";
        } else {
            if($tipoCuenta_id== 4){
                if($monto> $request->saldo) {
                    return response()->json(402);
                } else {
                    $movCaja = new movimientoCajas();
                    $movCaja->tipoCuenta_id = $tipoCuenta_id;
                    $movCaja->cuenta_id = $cuenta_id;
                    $movCaja->per_codigo = $request->per_codigo;
                    $movCaja->tipoSocio_id = $request->tipoSocio_id;
                    $movCaja->fecha = $fecha;
                    $movCaja->monto = $monto;
                    $movCaja->estado = '1';
                    $movCaja->obs = $request->observacion;
                    $movCaja->user_id = Auth::user()->id;
                    $movCaja->save();
                    return response()->json(200);
                }

            } else {
                $movCaja = new movimientoCajas();
                $movCaja->tipoCuenta_id = $tipoCuenta_id;
                $movCaja->cuenta_id = $cuenta_id;
                $movCaja->per_codigo = $request->per_codigo;
                $movCaja->tipoSocio_id = $request->tipoSocio_id;
                $movCaja->fecha = $fecha;
                $movCaja->monto = $monto;
                $movCaja->estado = '1';
                $movCaja->obs = $request->observacion;
                $movCaja->user_id = Auth::user()->id;
                $movCaja->save();
                return response()->json(200);
            }
        }
    }
}
