<?php

namespace App\Http\Controllers;

use App\JefeGrupos;
use App\PersonalCargo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class JefeGrupoController extends Controller
{
    public function listarJefeGrupo(Request $request) {
        if(!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;
        if($buscar == ''){
            $jefeGrupo = DB::table('jefeGrupos')
                    ->join('personals','personals.per_codigo','jefeGrupos.per_codigo')
                    ->join('grupos','grupos.id','jefeGrupos.grupo_id')
                    ->join('lineas','grupos.linea_id','lineas.id')
                    ->select(DB::raw("concat(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as apnombre"),
                            DB::raw("concat(grupos.grupo,' ',grupos.detalle,' ',grupos.alfabeto) as agrupacion"),
                            'personals.per_nombre',
                            'personals.per_paterno',
                            'personals.per_materno',
                            'personals.per_ci',
                            'grupos.grupo',
                            'grupos.detalle',
                            'grupos.alfabeto', 'lineas.descripcion as linea')
                    ->where('jefeGrupos.estado',1)
                    ->take(1)
                    ->paginate(10);
        }else{
            $jefeGrupo = DB::table('jefeGrupos')
                    ->join('personals','personals.per_codigo','jefeGrupos.per_codigo')
                    ->join('grupos','grupos.id','jefeGrupos.grupo_id')
                    ->join('lineas','grupos.linea_id','lineas.id')
                    ->select(DB::raw("concat(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as apnombre"),
                            DB::raw("concat(grupos.grupo,' ',grupos.detalle,' ',grupos.alfabeto) as agrupacion"),
                            'personals.per_nombre',
                            'personals.per_paterno',
                            'personals.per_materno',
                            'personals.per_ci',
                            'grupos.grupo',
                            'grupos.detalle',
                            'grupos.alfabeto', 'lineas.descripcion as linea')
                    ->where('jefeGrupos.estado',1)
                    ->where(function ( $query ) use ($buscar) {
                        $query->orWhere('personals.per_paterno','like',$buscar.'%')
                                ->orWhere('personals.per_materno','like',$buscar.'%')
                                ->orWhere('personals.per_nombre','like',$buscar.'%')
                                ->orWhere('personals.per_ci','like',$buscar.'%')
                                ->orWhere(DB::raw("concat(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre)"),'like',$buscar.'%')
                                ->orWhere('grupos.grupo','like',$buscar.'%')
                                ->orWhere('grupos.detalle','like',$buscar.'%')
                                ->orWhere('grupos.alfabeto','like',$buscar.'%')
                                ->orWhere(DB::raw("concat(grupos.grupo,' ',grupos.detalle,' ',grupos.alfabeto)"),'like',$buscar.'%');
                    })
                    ->take(1)
                    ->paginate(10);
        }
        return [
            'pagination' => [
                'total'         => $jefeGrupo->total(),
                'current_page'  => $jefeGrupo->currentPage(),
                'per_page'      => $jefeGrupo->perPage(),
                'last_page'     => $jefeGrupo->lastPage(),
                'from'          => $jefeGrupo->firstItem(),
                'to'            => $jefeGrupo->lastItem(),

            ],
            'jefeGrupo' => $jefeGrupo
        ];
        // return response()->json($jefeGrupo);
    }

    public function listarPersonalGrupo(Request $request)
    {
        if(!$request->ajax()) return redirect('/');
        $grupoId = $request->grupoId;
            $personalGrupo = DB::table('personals')
                    ->select('per_codigo',
                            DB::raw("CONCAT(per_nombre,' ',per_paterno,' ',per_materno) as personal")
                            )
                    ->where('estado',1)
                    ->where('grupo_id',$grupoId)
                    ->get();

        return response()->json($personalGrupo);
        // return response()->json($request);
    }

    public function designarJefeGrupo(Request $request)
    {
        $grupo = $request->grupo;
        $idPersona = $request->idPersona;
        $descripcion = $request->descripcion;
        $fecha_actual = date('Y-n-j');
        $ultimo_jefe = JefeGrupos::select('id',
                                        'per_codigo'
                                        )
                                ->where('grupo_id',$grupo)
                                ->where('estado',1)
                                ->get();

        $cantUltimoJefe = sizeof($ultimo_jefe);
        $arrayUltimoJefe = json_decode($ultimo_jefe,true);

        if($cantUltimoJefe != '0'){
            $i = 0;
            $update_preJefe = JefeGrupos::where('id',$arrayUltimoJefe[$i]['id'])
                                    ->first();
            $update_preJefe -> update([
                        'fechaFin' => $fecha_actual,
                        'estado' => 0
            ]);
            $designarJefe = JefeGrupos::create([
                'per_codigo' => $idPersona,
                'grupo_id' => $grupo,
                'fechaInicio' => $fecha_actual,
                // 'fechaFin' => $fecha_actual,
                'descripcion' => $descripcion,
                'estado' => 1,
                'user_id' => Auth::user()->id
            ]);
        }else{
            $designarJefe = JefeGrupos::create([
                'per_codigo' => $idPersona,
                'grupo_id' => $grupo,
                'fechaInicio' => $fecha_actual,
                // 'fechaFin' => $fecha_actual,
                'descripcion' => $descripcion,
                'estado' => 1,
                'user_id' => Auth::user()->id
            ]);
        }

        return response()->json('registro exitoso');
    }

    public function reporteJefeGrupo (){
        $jefeGrupos = DB::table('jefeGrupos')
        ->join('personals','personals.per_codigo','jefeGrupos.per_codigo')
        ->join('grupos','grupos.id','jefeGrupos.grupo_id')
        ->join('lineas','grupos.linea_id','lineas.id')
        ->select(DB::raw("concat(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as apnombre"),
                DB::raw("concat(grupos.grupo,' ',grupos.detalle,' ',grupos.alfabeto) as agrupacion"),
                'personals.per_nombre',
                'personals.per_paterno',
                'personals.per_materno',
                'personals.per_ci',
                'grupos.grupo',
                'grupos.detalle',
                'grupos.alfabeto', 'lineas.descripcion as linea')
        ->where('jefeGrupos.estado',1)
        ->get();

        $cargo1 = PersonalCargo::join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
        ->join('cargos','sindicatoCargos.cargo_id','cargos.id')
        ->select('cargos.descripcion',
        'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre')
        ->where('sindicatoCargos.estado',1)
        ->where('cargos.id',1)
        ->first();

        $total = DB::table('jefeGrupos')
        ->select(DB::raw('count(*) as count'))
        ->where('estado',1)
        ->first()
        ->count;

        $meses = array("ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");
        $fecha_emision = date('d')." DE ".$meses[date('n')-1]." DEL ".date('Y');
        $qr = QrCode::encoding('UTF-8')->size(100)->generate("SINDICATO DE TRANSPORTE 16 DE JULIO TRUFI 7\nTOTAL REGISTROS: $total\nFECHA: $fecha_emision");
        $codigo = $qr;
        $pdf = PDF::loadView('reportes.jefeGrupo',['jefeGrupos'=>$jefeGrupos,
                            'cargos'=>$cargo1,
                            'qr'=>$codigo])
        ->setPaper('letter', 'portrait');

        return $pdf->stream('Cargos.pdf');
    }
}
