<?php

namespace App\Http\Controllers;

use App\HojaRuta;
use App\hojaGenerada;
use App\movimientoCajas;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class HojasController extends Controller
{
    public function index(Request $request){
        if(!$request->ajax()) return redirect('/');
        $id = $request->per_codigo;
        $idInscription = DB::table('inscriptions')
        ->join('personals','inscriptions.persona_id','personals.per_codigo')
        ->select('inscriptions.id','inscriptions.persona_id',
        'inscriptions.estado','personals.tipoSocio_id')
        ->where('inscriptions.persona_id',$id)
        ->where('inscriptions.estado','1')
        ->first();
        $socio = $idInscription->tipoSocio_id;

        if($socio == 1){
            $list = DB::table('hojasGeneradas')
            ->join('fechas','hojasGeneradas.fecha_id','fechas.id')
            ->join('costoHojaRutas','fechas.costoHRSocio_id','costoHojaRutas.id')
            ->select('fechas.id','fechas.fechaGenerada','fechas.gestionInicio',
                    'fechas.mesInicio', 'fechas.fechaInicio', 'fechas.fechaFinal',
                    'fechas.gestionFinal', 'fechas.mesFinal', 'fechas.semana','fechas.mes',
                    'fechas.gestion', 'fechas.estado','costoHojaRutas.monto','fechas.costoHRSocio_id as costoHojaRuta_id',
                    'hojasGeneradas.estado','hojasGeneradas.id as hg_id','hojasGeneradas.tipoSocio_id','hojasGeneradas.per_codigo')
                    ->where('hojasGeneradas.estado',1)
                    ->where('hojasGeneradas.per_codigo',$id)
                    ->where('fechas.estado',1)
                    ->get();

                    return response()->json($list);
        }
        if($socio == 2) {
            $list = DB::table('hojasGeneradas')
            ->join('fechas','hojasGeneradas.fecha_id','fechas.id')
            ->join('costoHojaRutas','fechas.costoHRAsalariado_id','costoHojaRutas.id')
           ->select('fechas.id','fechas.fechaGenerada','fechas.gestionInicio',
                    'fechas.mesInicio', 'fechas.fechaInicio', 'fechas.fechaFinal',
                    'fechas.gestionFinal', 'fechas.mesFinal', 'fechas.semana','fechas.mes',
                    'fechas.gestion', 'fechas.estado','costoHojaRutas.monto','fechas.costoHRAsalariado_id as costoHojaRuta_id',
                    'hojasGeneradas.estado','hojasGeneradas.id as hg_id','hojasGeneradas.tipoSocio_id','hojasGeneradas.per_codigo')
                    ->where('hojasGeneradas.estado',1)
                    ->where('hojasGeneradas.per_codigo',$id)
                    ->where('fechas.estado',1)
                    ->get();

                    return response()->json($list);
        }
    }

    public function getFechaId(Request $request){
        if(!$request->ajax()) return redirect('/');
        $id = $request->id;
        $tipoSocio_id = $request->tipoSocio_id;
        if($tipoSocio_id == 1){
            $listId = DB::table('hojasGeneradas')
            ->join('fechas','hojasGeneradas.fecha_id','fechas.id')
            ->join('costoHojaRutas','fechas.costoHRSocio_id','costoHojaRutas.id')
            ->select('fechas.id','fechas.mesInicio', 'fechas.fechaInicio', 'fechas.fechaFinal',
                'fechas.gestionFinal', 'fechas.mesFinal', 'fechas.semana','fechas.mes',
                'fechas.gestion', 'fechas.estado','costoHojaRutas.monto',
                'fechas.costoHRSocio_id as costoHRSocio_id','hojasGeneradas.id as hg_id',
                'hojasGeneradas.per_codigo','hojasGeneradas.fecha_id')
                ->where('hojasGeneradas.id', $id)
                ->first();
                // return var_dump($listId->hg_id);
                return response()->json($listId);
        } if($tipoSocio_id == 2) {
            $listId = DB::table('hojasGeneradas')
            ->join('fechas','hojasGeneradas.fecha_id','fechas.id')
            ->join('costoHojaRutas','fechas.costoHRAsalariado_id','costoHojaRutas.id')
            ->select('fechas.id','fechas.mesInicio', 'fechas.fechaInicio', 'fechas.fechaFinal',
                'fechas.gestionFinal', 'fechas.mesFinal', 'fechas.semana','fechas.mes',
                'fechas.gestion', 'fechas.estado','costoHojaRutas.monto',
                'fechas.costoHRAsalariado_id as costoHRSocio_id','hojasGeneradas.id as hg_id',
                'hojasGeneradas.per_codigo','hojasGeneradas.fecha_id')
                ->where('hojasGeneradas.id', $id)
                ->first();
                // return var_dump($listId->hg_id);
                return response()->json($listId);
        }
    }

    public function store(Request $request){
        if(!$request->ajax()) return redirect('/');
        $fecha_actual = date('Y-m-d');
        $fecha_id = $request->fecha_id;
        $inscripcion_id = $request->inscripcion_id;
        $costoHRSocio_id = $request->costoHRSocio_id;
        $tarjeta = $request->tarjeta;
        $per_codigo = $request->per_codigo;
        $hg_id = $request->hg_id;
        $hojaRuta = HojaRuta::select('fecha_id','inscripcion_id','costohr_id','numTarjetaSemanal')
        ->where('fecha_id', $fecha_id)
        ->where('inscripcion_id', $inscripcion_id)
        ->where('costohr_id', $costoHRSocio_id)
        ->where('numTarjetaSemanal', $tarjeta)
        ->first();
        if(!empty($hojaRuta)){
            return response()->json(401);
        } else {
            try{
                $hojaRuta = new HojaRuta();
                $hojaRuta->fecha_id = $fecha_id;
                $hojaRuta->inscripcion_id = $request->inscripcion_id;
                $hojaRuta->costohr_id = $costoHRSocio_id;
                $hojaRuta->per_codigo = $per_codigo;
                $hojaRuta->tipoSocio_id = $request->tipoSocio_id;
                $hojaRuta->numTarjetaSemanal = $request->tarjeta;
                $hojaRuta->existeEnReporte = '1';
                $hojaRuta->estado = '1';
                $hojaRuta->user_id = Auth::user()->id;
                $hojaRuta->save();

                $caja = new movimientoCajas();
                $caja->tipoCuenta_id = 5;
                $caja->cuenta_id = 33;
                $caja->per_codigo = $per_codigo;
                $caja->tipoSocio_id = $request->tipoSocio_id;
                $caja->fecha = $fecha_actual;
                $caja->monto = $request->monto;
                $caja->estado = '1';
                $caja->user_id = Auth::user()->id;
                $caja->save();
                $this->StatusChange($hg_id);
                DB::commit();
                return response()->json(200);
            } catch (\Exception $e) {
                DB::rollBack();
                return response()->json(404);
            }

        }
    }

    public function StatusChange($hg_id){
        hojaGenerada::where('id', $hg_id)
            ->where('estado', 1)
            ->update(['estado' => 0]);
    }

    public function listFechasNoPagadasId(Request $request){
        if(!$request->ajax()) return redirect('/');
        $list = DB::table('hojasGeneradas')
            ->join('fechas','hojasGeneradas.fecha_id','fechas.id')
            ->join('costoHojaRutas','fechas.costoHRSocio_id','costoHojaRutas.id')
            ->select('fechas.id','fechas.fechaGenerada','fechas.gestionInicio',
                    'fechas.mesInicio', 'fechas.fechaInicio', 'fechas.fechaFinal',
                    'fechas.gestionFinal', 'fechas.mesFinal', 'fechas.semana','fechas.mes',
                    'fechas.gestion', 'fechas.estado','costoHojaRutas.monto','fechas.costoHRSocio_id as costoHojaRuta_id',
                    'hojasGeneradas.estado','hojasGeneradas.id as hg_id','hojasGeneradas.tipoSocio_id','hojasGeneradas.per_codigo')
                    ->where('hojasGeneradas.estado',1)
                    ->where('hojasGeneradas.per_codigo',$request->per_codigo)
                    ->where('fechas.estado',1)
                    ->get();

                    return response()->json($list);
    }

    public function listFechasPagadasId(Request $request){
        if(!$request->ajax()) return redirect('/');
        $list = DB::table('hojasGeneradas')
            ->join('fechas','hojasGeneradas.fecha_id','fechas.id')
            ->join('costoHojaRutas','fechas.costoHRSocio_id','costoHojaRutas.id')
            ->select('fechas.id','fechas.fechaGenerada','fechas.gestionInicio',
                    'fechas.mesInicio', 'fechas.fechaInicio', 'fechas.fechaFinal',
                    'fechas.gestionFinal', 'fechas.mesFinal', 'fechas.semana','fechas.mes',
                    'fechas.gestion', 'fechas.estado','costoHojaRutas.monto','fechas.costoHRSocio_id as costoHojaRuta_id',
                    'hojasGeneradas.estado','hojasGeneradas.id as hg_id','hojasGeneradas.tipoSocio_id','hojasGeneradas.per_codigo')
                    ->where('hojasGeneradas.estado',0)
                    ->where('hojasGeneradas.per_codigo',$request->per_codigo)
                    ->where('fechas.estado',1)
                    ->get();

                    return response()->json($list);
    }
}
