<?php

namespace App\Http\Controllers;

use App\CostoHojaRuta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class HojaRutaController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $hojaRutas = CostoHojaRuta::join('tipoSocios','costoHojaRutas.tipoSocio_id','tipoSocios.id')
            ->select('costoHojaRutas.id','tipoSocios.descripcion','costoHojaRutas.tipoSocio_id',
            'costoHojaRutas.fecha','costoHojaRutas.monto','costoHojaRutas.obs','costoHojaRutas.estado')
            ->orderBy('id','desc')
            ->paginate(10);
        } else {
            $hojaRutas = CostoHojaRuta::join('tipoSocios','costoHojaRutas.tipoSocio_id','tipoSocios.id')
            ->select('costoHojaRutas.id','tipoSocios.descripcion','costoHojaRutas.tipoSocio_id',
            'costoHojaRutas.fecha','costoHojaRutas.monto','costoHojaRutas.obs','costoHojaRutas.estado')
            ->where('tipoSocios','LIKE','%'.$request->buscar.'%')
            ->orderBy('id','desc')
            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $hojaRutas->total(),
                'current_page'  => $hojaRutas->currentPage(),
                'per_page'      => $hojaRutas->perPage(),
                'last_page'     => $hojaRutas->lastPage(),
                'from'          => $hojaRutas->firstItem(),
                'to'            => $hojaRutas->lastItem(),

            ],
            'hojaRutas' => $hojaRutas
        ]);
    }

    public function store(Request $request){
       // return response()->json($request->tipoSocio_id);
        if(!$request->ajax()) return redirect('/');
        $tipoSocio_id = $request->tipoSocio_id;
        $monto = $request->monto;
        $fecha = $request->fecha;
        $costoHojaRuta = CostoHojaRuta::select('tipoSocio_id','monto','fecha')
        ->where('tipoSocio_id', $tipoSocio_id)
        ->where('monto', $monto)
        ->where('fecha', $fecha)
        ->first();
        //return response()->json($doc);
        if(!empty($costoHojaRuta)){
            return response()->json("existe");
            //return "existe";
        } else {
            $estado = CostoHojaRuta::select('id','tipoSocio_id','estado')
            ->where('tipoSocio_id', $tipoSocio_id)
            ->where('estado', 1)->first();
            if(empty($estado)){
                $costoHojaRuta = new CostoHojaRuta();
                $costoHojaRuta->tipoSocio_id = $request->tipoSocio_id;
                $costoHojaRuta->fecha = $request->fecha;
                $costoHojaRuta->monto = $request->monto;
                $val = $request->observacion;

                if($val == ''){
                    $val = 'NINGUNO';
                }
                else{
                    $val = $request->observacion;
                }
                $costoHojaRuta->obs = $val;
                $costoHojaRuta->estado = '1';
                $costoHojaRuta->user_id = Auth::user()->id;
                $costoHojaRuta->save();
                return response()->json("exitoso");
            } else {
                try {
                    $estadoId = $estado->id;
                    DB::beginTransaction();
                    $this->Estado($estadoId);
                    $costoHojaRuta = new CostoHojaRuta();
                    $costoHojaRuta->tipoSocio_id = $request->tipoSocio_id;
                    $costoHojaRuta->fecha = $request->fecha;
                    $costoHojaRuta->monto = $request->monto;
                    $val = $request->observacion;

                    if($val == ''){
                        $val = 'NINGUNO';
                    }
                    else{
                        $val = $request->observacion;
                    }
                    $costoHojaRuta->obs = $val;
                    $costoHojaRuta->estado = '1';
                    $costoHojaRuta->user_id = Auth::user()->id;
                    $costoHojaRuta->save();
                    DB::commit();

                } catch (\Exception $e) {
                    DB::rollback();
                    return response()->json("falla");
                }
                return response()->json("exitoso");
            }
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
       // return response()->json($request->tipoSocio_id);
      // return var_dump($request->tipoSocio_id);
        $costoHojaRuta = CostoHojaRuta::findOrFail($request->id);
        $costoHojaRuta->tipoSocio_id = $request->tipoSocio_id;
        $costoHojaRuta->fecha = $request->fecha;
        $costoHojaRuta->monto = $request->monto;
        $costoHojaRuta->obs = $request->observacion;
        $costoHojaRuta->user_id = Auth::user()->id;
        $costoHojaRuta->save();

    }

    public function selectTipCuenta(Request $request) {
        if(!$request->ajax()) return view('/');
        $tipoCuentas = DB::table('cuentaTipos')
                            ->select('id as idcuentaTipos','cuentaTipo','obs','estado','user_id')
                            ->orderBy('id','asc')
                            ->get();
        return response()->json($tipoCuentas);
    }

    public function Estado($estadoId){
        CostoHojaRuta::where('id', $estadoId)
          ->where('estado', 1)
          ->update(['estado' => 0]);
    }

    public function Propietario(Request $request){
        if(!$request->ajax()) return view('/');
        $costoHRProp = DB::table('costoHojaRutas')
                            ->join('tipoSocios','costoHojaRutas.tipoSocio_id','tipoSocios.id')
                            ->select('costoHojaRutas.id','costoHojaRutas.monto','costoHojaRutas.estado','tipoSocios.descripcion')
                            ->where('tipoSocios.descripcion','=','PROPIETARIO')
                            ->where('costoHojaRutas.estado','1')
                            ->get();
        return response()->json($costoHRProp);
    }

    public function Asalariado(Request $request){
        if(!$request->ajax()) return view('/');
        $costoHRAsal = DB::table('costoHojaRutas')
                            ->join('tipoSocios','costoHojaRutas.tipoSocio_id','tipoSocios.id')
                            ->select('costoHojaRutas.id','costoHojaRutas.monto','costoHojaRutas.estado','tipoSocios.descripcion')
                            ->where('tipoSocios.descripcion','=','ASALARIADO')
                            ->where('costoHojaRutas.estado','1')
                            ->get();
        return response()->json($costoHRAsal);
    }

}
