<?php

namespace App\Http\Controllers;

use App\Grupo;
use App\PersonalCargo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class GrupoController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $grupos = Grupo::join('lineas','grupos.linea_id','lineas.id')
            ->select('grupos.id','grupos.linea_id','grupos.fecha','grupos.grupo','grupos.detalle','grupos.alfabeto',
            'grupos.obs','grupos.estado','grupos.user_id','lineas.descripcion')
            ->where('grupos.estado','1')
            ->orderBy('grupos.detalle','asc')
            ->paginate(10);
        } else {
            $grupos = Grupo::join('lineas','grupos.linea_id','lineas.id')
            ->select('grupos.id','grupos.linea_id','grupos.fecha','grupos.grupo','grupos.detalle','grupos.alfabeto',
            'grupos.obs','grupos.estado','grupos.user_id','lineas.descripcion')
            ->where('grupos.detalle','LIKE','%'.$request->buscar.'%')
                        ->orderBy('grupos.detalle','asc')
                        ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $grupos->total(),
                'current_page'  => $grupos->currentPage(),
                'per_page'      => $grupos->perPage(),
                'last_page'     => $grupos->lastPage(),
                'from'          => $grupos->firstItem(),
                'to'            => $grupos->lastItem(),

            ],
            'grupos' => $grupos
        ]);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $linea = $request->linea;
        $fecha = $request->fecha;
        $grupo = $request->grupo;
        $detalle = $request->detalle;
        $alfabeto = $request->alfabeto;
        $grupo = Grupo::select('linea_id','fecha','grupo','detalle','alfabeto')
        ->where('linea_id', $linea)
        ->where('fecha', $fecha)
        ->where('grupo', $grupo)
        ->where('detalle', $detalle)
        ->where('alfabeto', $alfabeto)
        ->first();
        //return response()->json($doc);
        if(!empty($grupo)){
            return response()->json("existe");
              //return "existe";
        } else {
            $grupo = new Grupo();
            $grupo->linea_id = $request->linea;
            $grupo->fecha = $request->fecha;
            $grupo->grupo = $request->grupo;
            $grupo->detalle = $request->detalle;
            $grupo->alfabeto = $request->alfabeto;
            $grupo->obs = $request->observacion;
            $grupo->estado = '1';
            $grupo->user_id = Auth::user()->id;
            $grupo->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
       //return response()->json($request);
        $id = $request->id;
        $linea_id = $request->linea_id;
        $fecha = $request->fecha;
        $grupo = $request->grupo;
        $detalle = $request->detalle;
        $alfabeto = $request->alfabeto;
        $grupo = Grupo::select('id','linea_id','fecha','grupo','detalle','alfabeto')
        ->where('linea_id', $linea_id)
        ->where('fecha', $fecha)
        ->where('grupo', $grupo)
        ->where('detalle', $detalle)
        ->where('alfabeto', $alfabeto)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($grupo)){
            return response()->json("existe");
             //return "existe";
        } else {
            $grupo = Grupo::findOrFail($request->id);
            $grupo->linea_id = $request->linea_id;
            $grupo->fecha = $request->fecha;
            $grupo->grupo = $request->grupo;
            $grupo->detalle = $request->detalle;
            $grupo->alfabeto = $request->alfabeto;
            $grupo->obs = $request->observacion;
            $grupo->estado = '1';
            $grupo->user_id = Auth::user()->id;
            $grupo->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $grupo           = Grupo::findOrFail($request->id);
        $grupo->estado   = $request->estado;
        $grupo->save();
    }

    public function selecBuscarGrupo(Request $request){
        $buscar = $request->linea_id;
       // return var_dump($buscar);
        if (!$request->ajax()) return redirect('/');
       $grupos = Grupo::where('linea_id','=',$buscar)
       ->where('estado','=','1')
       ->select('id as grupo_id','linea_id','detalle')->orderBy('id', 'asc')->get();
       return response()->json($grupos);
    }

    public function selectGrupos(Request $request)
    {
        $grupo = DB::table('grupos')
                ->select('id',
                        DB::raw("CONCAT(grupo,' ',detalle,' ',alfabeto) as agrupacion")
                        )
                ->where('estado',1)
                ->get();
        return response()->json($grupo);
    }

    public function gruposReporte(){
        $grupos = Grupo::join('lineas','grupos.linea_id','lineas.id')
        ->select('grupos.id','grupos.linea_id','grupos.fecha','grupos.grupo','grupos.detalle','grupos.alfabeto',
        'grupos.obs','grupos.estado','grupos.user_id','lineas.descripcion')
        ->where('grupos.estado','1')
        ->orderBy('grupos.detalle','asc')
        ->get();

        $cargo1 = PersonalCargo::join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
        ->join('cargos','sindicatoCargos.cargo_id','cargos.id')
        ->select('cargos.descripcion',
        'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre')
        ->where('sindicatoCargos.estado',1)
        ->where('cargos.id',1)
        ->first();

        $total = DB::table('grupos')
        ->select(DB::raw('count(*) as count'))
        ->where('estado',1)
        ->first()
        ->count;

        $meses = array("ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");
        $fecha_emision = date('d')." DE ".$meses[date('n')-1]." DEL ".date('Y');
        $qr = QrCode::encoding('UTF-8')->size(100)->generate("SINDICATO DE TRANSPORTE 16 DE JULIO TRUFI 7\nTOTAL REGISTROS: $total\nFECHA: $fecha_emision");
        $codigo = $qr;
        $pdf = PDF::loadView('reportes.grupos',['grupos'=>$grupos,
                            'cargos'=>$cargo1,
                            'qr'=>$codigo])
        ->setPaper('letter', 'portrait');

        return $pdf->stream('Cargos.pdf');
    }
}
