<?php

namespace App\Http\Controllers;

use App\Color;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ColorController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        if ($request->buscar == '') {
            $colores = Color::orderBy('color')
            ->paginate(10);
        } else {
            $colores = Color::where('color','LIKE','%'.$request->buscar.'%')
                        ->orderBy('color')
                        ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $colores->total(),
                'current_page'  => $colores->currentPage(),
                'per_page'      => $colores->perPage(),
                'last_page'     => $colores->lastPage(),
                'from'          => $colores->firstItem(),
                'to'            => $colores->lastItem(),

            ],
            'colores' => $colores
        ]);
    }

    public function store(Request $request){
        // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $color = $request->color;
        $color = Color::select('color')
        ->where('color', $color)
        ->first();
        //return response()->json($doc);
        if(!empty($color)){
            return response()->json("existe");
              //return "existe";
        } else {
            $color = new Color();
            $color->color = $request->color;
            $color->obs = $request->observacion;
            $color->estado = '1';
            $color->user_id = Auth::user()->id;
            $color->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
        //return response()->json($request);
        $id = $request->id;
        $color = $request->color;
        $color = Color::select('id','color')
        ->where('color', $color)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($color)){
            return response()->json("existe");
             //return "existe";
        } else {
            $color = Color::findOrFail($request->id);
            $color->color = $request->color;
            $color->obs = $request->observacion;
            $color->estado = '1';
            $color->user_id = Auth::user()->id;
            $color->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $color           = Color::findOrFail($request->id);
        $color->estado   = $request->estado;
        $color->save();
    }

    public function ComboSelectColor(Request $request){
        if(!$request->ajax()) return view('/');
        $colores = DB::table('colores')
                            ->select('id as color_id','color')
                            ->where('estado','1')
                            ->orderBy('color','asc')
                            ->get();
        return response()->json($colores);
    }
}
