<?php
namespace App\Http\Controllers;

use App\Car;
use App\PersonalCargo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

use Illuminate\Http\Request;

class CarsController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');
        $buscar = $request->buscar;
        if ($buscar == '') {
            $cars = Car::join('personals','cars.per_codigo','personals.per_codigo')
            ->join('marcas','cars.marca_id','marcas.id')
            ->join('tipoCars','cars.tipo_id','tipoCars.id')
            ->join('colores','cars.color_id','colores.id')
            ->join('lineas','cars.linea_id','lineas.id')
            ->join('grupos','cars.grupo_id','grupos.id')
            ->select('cars.id','cars.per_codigo','cars.marca_id','cars.tipo_id','cars.color_id','cars.linea_id','cars.grupo_id','cars.placa',
            'cars.rua','cars.modelo','cars.fechaRegistro','cars.estado','cars.user_id','marcas.marca','colores.color',
            'lineas.descripcion','grupos.detalle','tipoCars.tipo',
            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as propietario"))
            ->where('cars.estado',1)
            ->orderBy('cars.placa','desc')
            ->paginate(10);
        } else {
            $cars = Car::join('personals','cars.per_codigo','personals.per_codigo')
            ->join('marcas','cars.marca_id','marcas.id')
            ->join('tipoCars','cars.tipo_id','tipoCars.id')
            ->join('colores','cars.color_id','colores.id')
            ->join('lineas','cars.linea_id','lineas.id')
            ->join('grupos','cars.grupo_id','grupos.id')
            ->select('cars.id','cars.per_codigo','cars.marca_id','cars.tipo_id','cars.color_id','cars.linea_id','cars.grupo_id','cars.placa',
            'cars.rua','cars.modelo','cars.fechaRegistro','cars.estado','cars.user_id','marcas.marca','colores.color',
            'lineas.descripcion','grupos.detalle','tipoCars.tipo',
            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre) as propietario"))
            ->where(function ( $query ) use ($buscar) {
                $query->orWhere('placa','like',$buscar.'%')
                        ->orWhere('rua','like',$buscar.'%')
                        ->orWhere('marca','like',$buscar.'%')
                        ->orWhere('color','like',$buscar.'%')
                        ->orWhere('detalle','like',$buscar.'%')
                        ->orWhere( DB::raw("CONCAT(per_paterno,' ',per_materno,' ',per_nombre)"),'like',$buscar.'%');
            })

            ->orderBy('cars.placa','desc')
            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $cars->total(),
                'current_page'  => $cars->currentPage(),
                'per_page'      => $cars->perPage(),
                'last_page'     => $cars->lastPage(),
                'from'          => $cars->firstItem(),
                'to'            => $cars->lastItem(),

            ],
            'cars' => $cars
        ]);
    }

    public function store(Request $request){
       // return response()->json($request);
        if(!$request->ajax()) return redirect('/');
        $placa = $request->placa;
        $rua = $request->rua;
        $modelo = $request->modelo;
        $car = Car::select('placa','rua','modelo')
        ->where('placa', $placa)
        ->where('rua', $rua)
        ->where('modelo', $modelo)
        ->first();
        //return response()->json($doc);
        if(!empty($car)){
            return response()->json("existe");
              //return "existe";
        } else {
            $car = new Car();
            $car->per_codigo = $request->per_codigo;
            $car->linea_id = $request->linea_id;
            $car->grupo_id = $request->grupo_id;
            $car->marca_id = $request->marca_id;
            $car->tipo_id = $request->tipo_id;
            $car->color_id = $request->color_id;
            $car->rua = $request->rua;
            $car->placa = $request->placa;
            $car->modelo = $request->modelo;
            $car->fechaRegistro = $request->fechaRegistro;
           /* $val = $request->observacion;

            if($val == ''){
                $val = 'NINGUNO';
            }
            else{
                $val = $request->observacion;
            }
            $car->observacion = $val; */
            $car->estado = '1';
            $car->user_id = Auth::user()->id;
            $car->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');
       // return response()->json($request->color_id);
        $id = $request->id;
        $placa = $request->placa;
        $rua = $request->rua;
        $modelo = $request->modelo;
        $car = Car::select('placa','rua','modelo')
        ->where('placa', $placa)
        ->where('rua', $rua)
        ->where('modelo', $modelo)
        ->whereNotIn('id', [$id])
        ->first();
        if(!empty($car)){
            return response()->json("existe");
             //return "existe";
        } else {
            $car = Car::findOrFail($request->id);
            $car->per_codigo = $request->per_codigo;
            $car->linea_id = $request->linea_id;
            $car->grupo_id = $request->grupo_id;
            $car->marca_id = $request->marca_id;
            $car->tipo_id = $request->tipo_id;
            $car->color_id = $request->color_id;
            $car->rua = $request->rua;
            $car->placa = $request->placa;
            $car->modelo = $request->modelo;
            $car->fechaRegistro = $request->fechaRegistro;
            $car->estado = '1';
            $car->user_id = Auth::user()->id;
            $car->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');
        $Cuentas           = Car::findOrFail($request->id);
        $Cuentas->estado   = $request->estado;
        $Cuentas->save();
    }

    public function ReporteCars(Request $request){
      //  if (!$request->ajax()) return redirect('/');
        $cars = Car::join('personals','cars.per_codigo','personals.per_codigo')
            ->join('marcas','cars.marca_id','marcas.id')
            ->join('tipoCars','cars.tipo_id','tipoCars.id')
            ->join('colores','cars.color_id','colores.id')
            ->join('lineas','cars.linea_id','lineas.id')
            ->join('grupos','cars.grupo_id','grupos.id')
            ->select('cars.id','cars.per_codigo','cars.marca_id','cars.tipo_id','cars.color_id','cars.linea_id','cars.grupo_id','cars.placa',
            'cars.rua','cars.modelo','cars.fechaRegistro','cars.estado','cars.user_id','marcas.marca','colores.color',
            'lineas.descripcion','grupos.detalle','tipoCars.tipo',
            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as propietario"))
            ->where('cars.estado',1)
            ->orderBy('cars.placa','desc')
            ->get();

        $minibuses = DB::table('cars')
            ->select(DB::raw('count(*) as count'))
            ->where('linea_id',1)
            ->where('estado',1)
            ->first()
            ->count;

        $carrys = DB::table('cars')
            ->select(DB::raw('count(*) as count'))
            ->where('linea_id',2)
            ->where('estado',1)
            ->first()
            ->count;

        $taxis = DB::table('cars')
            ->select(DB::raw('count(*) as count'))
            ->where('linea_id',3)
            ->where('estado',1)
            ->first()
            ->count;
        $total = DB::table('cars')
            ->select(DB::raw('count(*) as count'))
            ->where('estado',1)
            ->first()
            ->count;

        $cargo1 = PersonalCargo::join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
                                    ->join('cargos','sindicatoCargos.cargo_id','cargos.id')
                                    ->select('cargos.descripcion',
                                    'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre')
                                    ->where('sindicatoCargos.estado',1)
                                    ->where('cargos.id',1)
                                    ->first();
      //  return var_dump($cargo1->paterno);
        $meses = array("ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");
        $fecha_emision = date('d')." DE ".$meses[date('n')-1]." DEL ".date('Y');
        $qr = QrCode::encoding('UTF-8')->size(100)->generate("SINDICATO DE TRANSPORTE 16 DE JULIO TRUFI 7\nMINIBUSES: $minibuses \nCARRYS: $carrys\nTAXIS: $taxis\nTOTAL REGISTROS: $total\nFECHA: $fecha_emision");
        $codigo = $qr;
        $pdf = PDF::loadView('reportes.reporteCars',['cars'=>$cars,
                                                    'cargos'=>$cargo1,
                                                    'qr'=>$codigo])
                    ->setPaper('letter', 'landscape');

        return $pdf->stream('movilidades.pdf');
    }

    public function listId(Request $request){
        if (!$request->ajax()) return redirect('/');
        $cars = Car::join('personals','cars.per_codigo','personals.per_codigo')
            ->join('marcas','cars.marca_id','marcas.id')
            ->join('tipoCars','cars.tipo_id','tipoCars.id')
            ->join('colores','cars.color_id','colores.id')
            ->join('lineas','cars.linea_id','lineas.id')
            ->join('grupos','cars.grupo_id','grupos.id')
            ->select('cars.id','cars.per_codigo','cars.marca_id','cars.tipo_id','cars.color_id','cars.linea_id','cars.grupo_id','cars.placa',
            'cars.rua','cars.modelo','cars.fechaRegistro','cars.estado','cars.user_id','marcas.marca','colores.color',
            'lineas.descripcion','grupos.detalle','tipoCars.tipo',
            DB::raw("CONCAT(personals.per_paterno,' ',personals.per_materno,' ',personals.per_nombre,' ',personals.per_ci) as propietario"))
            ->where('cars.estado',1)
            ->where('cars.per_codigo',$request->per_codigo)
            ->orderBy('cars.placa','desc')
            ->get();
        return response()->json([  'cars' => $cars]);
    }
}
