<?php

namespace App\Http\Controllers;

use App\Cargo;
use App\PersonalCargo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade as PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class CargoController extends Controller
{
    public function index(Request $request){
        if (!$request->ajax()) return redirect('/');

        if ($request->buscar == '') {
            $cargos = Cargo::select('id','descripcion','observacion','estado')
                            ->orderBy('id')
                            ->paginate(10);
        } else {
            $cargos = Cargo::select('id','descripcion','observacion','estado')
                            ->where('descripcion','LIKE','%'.$request->buscar.'%')
                            ->orderBy('id')
                            ->paginate(10);
        }
        return response()->json([
            'pagination' => [
                'total'         => $cargos->total(),
                'current_page'  => $cargos->currentPage(),
                'per_page'      => $cargos->perPage(),
                'last_page'     => $cargos->lastPage(),
                'from'          => $cargos->firstItem(),
                'to'            => $cargos->lastItem(),

            ],
            'cargos' => $cargos
        ]);
    }

    public function store(Request $request){
        if(!$request->ajax()) return redirect('/');

        $descripcion = $request->descripcion;
        $cargos = Cargo::select('descripcion')
                        ->where('descripcion', $descripcion)
                        ->first();
        if(!empty($cargos)){
            return response()->json("existe");
        } else {
            $cargos = new Cargo();
            $cargos->descripcion = $request->descripcion;
            $val = $request->observacion;

            if($val == ''){
                $val = 'NINGUNO';
            }
            else{
                $val = $request->observacion;
            }
            $cargos->observacion    =   $val;
            $cargos->estado         =   '1';
            $cargos->sysuser        =   Auth::user()->id;
            $cargos->save();
        }
    }

    public function update(Request $request){
        if (!$request->ajax()) return redirect('/');

        $id = $request->id;
        $descripcion = $request->descripcion;
        $cargos = Cargo::select('id','descripcion')
                        ->where('descripcion', $descripcion)
                        ->whereNotIn('id', [$id])
                        ->first();

        if(!empty($cargos)){
            return response()->json("existe");
        } else {
            $cargos                 =   Cargo::findOrFail($request->id);
            $cargos->descripcion    =   $request->descripcion;
            $val                    =   $request->observacion;

            if($val == ''){
                $val = 'NINGUNA';
            }
            else{
                $val = $request->observacion;
            }
            $cargos->observacion    =   $val;
            $cargos->sysuser        =   Auth::user()->id;
            $cargos->save();
        }
    }

    public function stateChange(Request $request){
        if(!$request->ajax()) return redirect('/');

        $cargos           = Cargo::findOrFail($request->id);
        $cargos->estado   = $request->estado;
        $cargos->save();
    }

    public function ReporteCargo(Request $request){
        $cargos = Cargo::select('id','descripcion','observacion','estado')
        ->orderBy('id')->get();

        $cargo1 = PersonalCargo::join('personals','sindicatoCargos.per_codigo','personals.per_codigo')
        ->join('cargos','sindicatoCargos.cargo_id','cargos.id')
        ->select('cargos.descripcion',
        'personals.per_paterno as paterno','personals.per_materno as materno','personals.per_nombre as nombre')
        ->where('sindicatoCargos.estado',1)
        ->where('cargos.id',1)
        ->first();

        $total = DB::table('cargos')
        ->select(DB::raw('count(*) as count'))
        ->where('estado',1)
        ->first()
        ->count;

        $meses = array("ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");
        $fecha_emision = date('d')." DE ".$meses[date('n')-1]." DEL ".date('Y');
        $qr = QrCode::encoding('UTF-8')->size(100)->generate("SINDICATO DE TRANSPORTE 16 DE JULIO TRUFI 7\nTOTAL REGISTROS: $total\nFECHA: $fecha_emision");
        $codigo = $qr;
        $pdf = PDF::loadView('reportes.Cargos',['Cargos'=>$cargos,
                            'cargos'=>$cargo1,
                            'qr'=>$codigo])
        ->setPaper('letter', 'portrait');

        return $pdf->stream('Cargos.pdf');
    }
}
