<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// LOGIN
Route::post('/authenticate/ingreso','Auth\LoginController@login');
Route::get('/authenticate/salir','Auth\LoginController@logout')->name('logout');

// USUARIOS
Route::get('/datosP','UsuarioController@datosP');
Route::get('/datosUsuario','UsuarioController@DatosUsuario');
Route::post('/listarUsuarios','UsuarioController@ListarUsuarios');
Route::post('/datosUsuarios','UsuarioController@DatosUsuarios');
Route::put('/editarUsuarios','UsuarioController@EditarUsuario');
Route::put('/desactivarUsuario', 'UsuarioController@desactivarUsuario');
Route::put('/activarUsuario', 'UsuarioController@activarUsuario');
Route::post('/crearUsuario','UsuarioController@CrearUsuario');
Route::post('/usuario/AgregarUsuario','UsuarioController@AgregarUsuario');
Route::post('/usuario/registroUser','UsuarioController@store');
Route::post('/editContrasena','UsuarioController@EditContrasena');

// MODULOS DEL SISTEMA
Route::post('/registrarModulo','ModulosController@registrarModulo');
Route::post('/ListarModulos','ModulosController@ListarModulos');
Route::put('/desactivarModulo', 'ModulosController@desactivarModulo');
Route::put('/activarModulo', 'ModulosController@activarModulo');
Route::put('/actualizarModulo', 'ModulosController@actualizarModulo');
Route::get('/selectModulos','ModulosController@selectModulos');

// PERMISOS
Route::post('/registrarPermiso','PermisosController@registrarPermiso');
Route::post('/ListarPermisos','PermisosController@ListarPermisos');
Route::put('/desactivarPermiso', 'PermisosController@desactivarPermiso');
Route::put('/activarPermiso', 'PermisosController@activarPermiso');
Route::put('/actualizarPermiso', 'PermisosController@actualizarPermiso');
Route::post('/listPermisos','PermisosController@ListPermisos');

// ROLES
Route::post('/guardarRol','RoleController@GuardarRol');
Route::post('/ListarRol','RoleController@ListarRol');
Route::get('/roles/selectRol','RoleController@selectRol');
Route::post('/listaRolPermiso','RoleController@ListaRolPermiso');
Route::post('/editarRol','RoleController@EditarRol');
Route::post('/desactivarRol', 'RoleController@desactivarRol');
Route::post('/activarRol', 'RoleController@activarRol');

Route::get('/listarRoles','RoleController@ListarRoles');

/* ************************* LISTAR PERSONAL ************************************* */
Route::post('/PersonalList', 'PersonalController@index');
Route::post('/PersonalListMain', 'PersonalController@MainList');
Route::post('/registrarPersonal','PersonalController@RegistrarPersonal');
Route::post('/registrarPersonalAsalariado','PersonalController@RegistrarAsalariado');
Route::post('/registrarPersonalContrato','PersonalController@RegistrarContrato');
Route::get('/personal/comboSelectPersonal','PersonalController@comboSelectPersonal');
Route::get('/personals/reporte','PersonalController@createPDF');
// PERSONAL
Route::get('/listarPersonal','PersonalController@listarPersonal');
Route::post('/datosdePersonal','PersonalController@DatosPersonal');
Route::post('/datosPersonalUser','PersonalController@DatosPersonalesAcceso');
Route::post('/datosPersonales','PersonalController@datosPersonalesRuta');
Route::post('/verDatosPersonales','PersonalController@VerDatosPersonales');
Route::put('/editarDatosPersonales','PersonalController@EditarDatosPersonales');
Route::get('/reportes/memorandum','PersonalController@Memorandum');

/******************************TIPO SOCIO***************************************/
Route::post('tipoSocio/Listar','TipoSocioController@index');
Route::post('/tipoSocio/registrar','TipoSocioController@store');
Route::put('/tipoSocio/actualizar','TipoSocioController@update');
Route::post('/tipoSocio/cambiarEstado','TipoSocioController@stateChange');
Route::get('/tiposocio/selectTipoSocio','TipoSocioController@selectTipoSocio');

/******************************LINEAS***************************************/
Route::post('/line/selectLine','LineController@selectLine');
Route::get('/line/comboSelectLine','LineController@ComboSelectLine');

/******************************MARCA***************************************/
Route::post('marca/Listar','MarcaController@index');
Route::post('/marca/registrar','MarcaController@store');
Route::put('/marca/actualizar','MarcaController@update');
Route::post('/marca/cambiarEstado','MarcaController@stateChange');
Route::post('/marca/comboSelectMarca','MarcaController@comboSelectMarca');

/******************************CATEGORIAS***************************************/
Route::get('/categorias/selectCategorias','CategoriaController@selectCategory');

/******************************COLORES***************************************/
Route::post('colores/Listar','ColorController@index');
Route::post('/colores/registrar','ColorController@store');
Route::put('/colores/actualizar','ColorController@update');
Route::post('/colores/cambiarEstado','ColorController@stateChange');
Route::get('/color/comboSelectColor','ColorController@comboSelectColor');

/******************************CARS***************************************/
Route::post('/cars/Listar','CarsController@index');
Route::post('/cars/registrar','CarsController@store');
Route::put('/cars/actualizar','CarsController@update');
Route::post('/cars/cambiarEstado','CarsController@stateChange');
Route::get('/cars/reporte', 'CarsController@ReporteCars');
Route::post('/cars/listCarId','CarsController@listId');

/******************************TIPO CARS***************************************/
Route::post('/tipoCars/Listar','TipoCarController@index');
Route::post('/tipoCars/registrar','TipoCarController@store');
Route::put('/tipoCars/actualizar','TipoCarController@update');
Route::post('/tipoCars/cambiarEstado','TipoCarController@stateChange');
Route::post('/tipoCars/comboSelectTipoCar','TipoCarController@comboSelectTipoCar');

/******************************GRUPOS***************************************/
Route::post('/grupos/Listar','GrupoController@index');
Route::post('/grupos/registrar','GrupoController@store');
Route::put('/grupos/actualizar','GrupoController@update');
Route::post('/grupo/stateChange','GrupoController@stateChange');
Route::post('/grupo/selectBuscarGrupo','GrupoController@selecBuscarGrupo');
Route::get('/grupos/reporte', 'GrupoController@gruposReporte');

/******************************CARGOS***************************************/
Route::post('/cargos/Listar','CargoController@index');
Route::post('/cargos/registrar','CargoController@store');
Route::put('/cargos/actualizar','CargoController@update');
Route::post('/cargos/stateChange','CargoController@stateChange');
Route::post('/cargos/selectBuscarCargo','CargoController@selectBuscarCargo');
Route::get('/cargos/reporte', 'CargoController@ReporteCargo');

/******************************PERSONAL CARGOS***************************************/
Route::post('/percargos/Listar','PersonalCargoController@index');
Route::post('/percargos/registrar','PersonalCargoController@store');
Route::put('/percargos/actualizar','PersonalCargoController@update');
Route::post('/percargos/stateChange','PersonalCargoController@stateChange');
Route::post('/selectcargo','PersonalCargoController@selectCargo');
Route::post('/selectpersonal','PersonalCargoController@selectPersonal');
Route::post('/selectCargosPersonal','PersonalCargoController@selectCargosPersonal');
Route::get('/percargos/reporte', 'PersonalCargoController@ReportePersonalCargo');

/******************************COSTO HOJA DE RUTA ***************************************/
Route::post('/costoHojaRuta/Listar','HojaRutaController@index');
Route::post('/costoHojaRuta/registrar','HojaRutaController@store');
Route::put('/costoHojaRuta/actualizar','HojaRutaController@update');
Route::get('/costoHojaRuta/Propietario','HojaRutaController@Propietario');
Route::get('/costoHojaRuta/Asalariado','HojaRutaController@Asalariado');

/******************************HOJA DE RUTA ***************************************/
Route::post('/listarHojasRuta','HojasController@index');
Route::post('/HojaRuta/registrar','HojasController@store');
Route::post('/listarHojasRutaId','HojasController@getFechaId');
Route::post('/HojaRuta/listId/NoPagadas','HojasController@listFechasNoPagadasId');
Route::post('/HojaRuta/listId/Pagadas','HojasController@listFechasPagadasId');

/******************************CAJA ***************************************/
Route::get('/caja/ingresos','MovimientoCajaController@ingresos');
Route::get('/caja/egresos','MovimientoCajaController@egresos');
Route::post('caja/index','MovimientoCajaController@index');
Route::post('caja/registro','MovimientoCajaController@store');

/******************************FECHAS *********************************/
Route::post('fechas/Listar','FechaController@index');
Route::post('/fechas/registrar','FechaController@store');
Route::put('/fechas/actualizar','FechaController@update');
Route::post('/fechas/cambiarEstado','FechaController@stateChange');
Route::post('/fechas/comboSelectFechas','FechaController@selectFechas');


/******************************TIPO CUENTA***************************************/
Route::post('/tipoCuenta/Listar','TipoCuentasController@index');
Route::post('/tipoCuenta/registrar','TipoCuentasController@store');
Route::put('/tipoCuenta/actualizar','TipoCuentasController@update');
Route::post('/tipoCuenta/cambiarEstado','TipoCuentasController@stateChange');
//LISTADO TIPO CUENTA - CUENTA
Route::post('/tipcuenta/selectTipCuenta','TipoCuentasController@selectTipCuenta');

/******************************CUENTAS***************************************/
Route::post('/cuenta/Listar','CuentasController@index');
Route::post('/cuenta/registrar','CuentasController@store');
Route::put('/cuenta/actualizar','CuentasController@update');
Route::post('/cuenta/cambiarEstado','CuentasController@stateChange');
Route::get('/cuentas/reporte', 'CuentasController@reporteCuentas');
Route::post('/cuenta/selectCuentas','CuentasController@selectCuentas');

/* ************************* JEFE GRUPO ************************************* */
Route::post('/JefeGrupoList', 'JefeGrupoController@listarJefeGrupo');
Route::get('/listarGrupos','GrupoController@selectGrupos');
Route::post('/listarPersonalGrupos','JefeGrupoController@listarPersonalGrupo');
Route::post('/jefeGrupo/designar','JefeGrupoController@designarJefeGrupo');
Route::get('/jefeGrupo/reporte', 'JefeGrupoController@reporteJefeGrupo');

Route::get('/{optional?}', function () {
    return view('app');
})->name('basepath')
   ->where('optional','.*');
